IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_FP_FUNC_EXTRATO_VALE]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_FP_FUNC_EXTRATO_VALE]
GO

/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 20220318
'Job.................:  
'Nome................: [UFD_FP_FUNC_EXTRATO_VALE] 
'Objetivo............:
'Tabelas.............: 
'Dt Criação..........: 
'Criado por..........: 
'Dt Ult Alteracão....: 18/03/2022
'Alterado por........: Marcos Barros

'=======================================================================================
-- FARMAGOI-28080 -  substituindo o INNER JOIN por  LEFT JOIN, dessa forma retornando tanto o vales realizados pelo fechamento de caixa quanto pelo Lançamentos de Vales de Funcionários
*/

--SELECT CD_EMP,CD_FILIAL,CD_FUN,NM_FUN,DT_VALE,DS_VALE,VLR_VALE FROM  UFD_FP_FUNC_EXTRATO_VALE(1,'2009-09-16','2009-09-17') ORDER BY CD_FUN,DT_VALE, TP_TRANSA DESC

CREATE FUNCTION [dbo].[UFD_FP_FUNC_EXTRATO_VALE](@CD_EMP				INT,
												@DT_INI				DATETIME,
												@DT_FIM				DATETIME)

RETURNS @FP_FUNC_EXTRATO_VALE TABLE (CD_EMP				INT,
									CD_FILIAL			INT,
									CD_FUN				INT,
									NM_FUN 			    VARCHAR(50) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AI,
									DT_VALE  			DATETIME, 
									DS_VALE 			VARCHAR(200), 
									VLR_VALE			MONEY,
                                    VLR_SLD_VALE        MONEY,
                                    TP_TRANSA           INT,
									ORIG_LANC           VARCHAR(30),
									CPF                 VARCHAR(20),
									NM_USU		     VARCHAR(50)) AS
BEGIN
DECLARE @RS_MOV TABLE (CD_EMP		 INT, 
						CD_FILIAL	 INT,	
						CD_FUN		 INT,			
						NM_FUN		 VARCHAR(50), 
						DT_VALE		 DATETIME,
						DS_VALE		 VARCHAR(200), 
						VLR_VALE	 MONEY, 
						VLR_SLD_VALE MONEY, 
						TP_TRANSA	 INT,
						CPF          VARCHAR(20),
						DIF_CAIXA	  INT,
						NM_USU		VARCHAR(50))

INSERT INTO @RS_MOV 
	SELECT      
		FP_FUNC.CD_EMP,
		ISNULL(C.CD_FILIAL,0) AS CD_FILIAL,
		FP_FUNC.CD_FUN, 
		FP_FUNC.NM_FUN, 
		FP_FUNC_VALE_CREDITO.DT_VALE,             
		FP_FUNC_VALE_CREDITO.DS_VALE, 
		FP_FUNC_VALE_CREDITO.VLR_VALE, 
		0,
		0 AS TP_TRANSA,
		CPF_FUN,
		ISNULL(FP_FUNC_VALE_CREDITO.DIF_CAIXA,0),
		ISNULL(U.NM_USU,'') AS NM_USU
	FROM        
		FP_FUNC 
		INNER JOIN FP_FUNC_VALE_CREDITO ON 
		FP_FUNC.CD_EMP = FP_FUNC_VALE_CREDITO.CD_EMP AND 
		FP_FUNC.CD_FUN = FP_FUNC_VALE_CREDITO.CD_FUN

		LEFT JOIN (
			SELECT
				CD_EMP,
				CD_FUNC_VALE_CRED,
				CD_FILIAL
			FROM
				PDV_VD_FECHA_MOV_ADIANTAMENTO_FP_FUNC_VALE_CREDITO C
			UNION
			SELECT
				CD_EMP,
				CD_FUNC_VALE_CRED,
				CD_FILIAL
			FROM
				PDV_VD_FECHA_MOV_FP_FUNC_VALE_CREDITO CC) C ON
		FP_FUNC_VALE_CREDITO.CD_EMP				= C.CD_EMP AND 
		FP_FUNC_VALE_CREDITO.CD_FUNC_VALE_CRED  = C.CD_FUNC_VALE_CRED 

		LEFT JOIN GLB_USU U ON 
			FP_FUNC_VALE_CREDITO.CD_USU=U.CD_USU
	WHERE       
		FP_FUNC_VALE_CREDITO.CD_EMP = @CD_EMP 
		AND FP_FUNC_VALE_CREDITO.DT_VALE BETWEEN  @DT_INI AND @DT_FIM
	UNION ALL
	SELECT      
		FP_FUNC.CD_EMP, 
		0,
		FP_FUNC.CD_FUN, 
		FP_FUNC.NM_FUN, 			
		FP_FUNC_VALE_DEBITO.DT_VALE_DEB , 
		'REFERENTE BAIXA DE ADIANTAMENTO NO DIA ' + CAST(CONVERT(CHAR(10),FP_FUNC_VALE_DEBITO.DT_CAD,103) AS VARCHAR) AS DS_VALE, 			
		FP_FUNC_VALE_DEBITO.VLR_VALE_DEB * -1,            
		0,			 
		1 AS TP_TRANSA,
		CPF_FUN,
		0,
		ISNULL(U.NM_USU,'') AS NM_USU
	FROM        
		FP_FUNC 
		INNER JOIN FP_FUNC_VALE_DEBITO ON 
			FP_FUNC.CD_EMP = FP_FUNC_VALE_DEBITO.CD_EMP AND 
			FP_FUNC.CD_FUN = FP_FUNC_VALE_DEBITO.CD_FUN LEFT JOIN GLB_USU U ON 
			FP_FUNC_VALE_DEBITO.CD_USU=U.CD_USU
	WHERE       
		FP_FUNC_VALE_DEBITO.CD_EMP = @CD_EMP 
		AND FP_FUNC_VALE_DEBITO.DT_VALE_DEB  BETWEEN   @DT_INI AND @DT_FIM
	ORDER BY 
		FP_FUNC_VALE_CREDITO.DT_VALE, 
		TP_TRANSA
------------------------------------------------------------------------------------
INSERT INTO @FP_FUNC_EXTRATO_VALE (CD_EMP, 
								   CD_FILIAL,	
								   CD_FUN, 
								   NM_FUN, 
								   DT_VALE, 
								   DS_VALE, 
						           VLR_VALE, 
								   VLR_SLD_VALE, 
								   TP_TRANSA,
								   ORIG_LANC,
								   CPF,
								   NM_USU) 
	SELECT		
		VALE.CD_EMP, 
		0 CD_FILIAL,
		VALE.CD_FUN, 
		VALE.NM_FUN, 
		@DT_INI -1 AS DT_VALE, 
		' SALDO ANTERIOR À ' +  + CONVERT(VARCHAR(10),@DT_INI -1,103) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AI AS DS_VALE, 
		ISNULL(VALE.VLR_SLD_VALE,0) VLR_SLD_VALE, 
		0,
		2 AS TP_TRANSA,
		'SALDO ANTERIOR',
		CPF_FUN,
		'' AS NM_USU
	FROM		
		(SELECT		
						CD_EMP,
						CD_FUN,
						NM_FUN,
						SUM(VLR_CRED) - SUM(VLR_DEB) VLR_SLD_VALE,
						CPF_FUN
					FROM
						(SELECT      
							FP_FUNC.CD_EMP, 
							FP_FUNC.CD_FUN, 
							FP_FUNC.NM_FUN,             
							FP_FUNC_VALE_CREDITO.VLR_VALE VLR_CRED, 
							0 VLR_DEB ,
							0 AS TP_TRANSA,
							CPF_FUN
						FROM        
							FP_FUNC 
							INNER JOIN FP_FUNC_VALE_CREDITO ON 
							FP_FUNC.CD_EMP = FP_FUNC_VALE_CREDITO.CD_EMP AND 
							FP_FUNC.CD_FUN = FP_FUNC_VALE_CREDITO.CD_FUN
						WHERE       
							FP_FUNC_VALE_CREDITO.CD_EMP = 1 
							AND FP_FUNC_VALE_CREDITO.DT_VALE < @DT_INI 
						UNION ALL
						SELECT     
							FP_FUNC.CD_EMP, 
							FP_FUNC.CD_FUN, 
							FP_FUNC.NM_FUN,             
							0,			            
							FP_FUNC_VALE_DEBITO.VLR_VALE_DEB,             
							1 AS TP_TRANSA,
							CPF_FUN
						FROM        
							FP_FUNC 
							INNER JOIN FP_FUNC_VALE_DEBITO ON 
							FP_FUNC.CD_EMP = FP_FUNC_VALE_DEBITO.CD_EMP AND 
							FP_FUNC.CD_FUN = FP_FUNC_VALE_DEBITO.CD_FUN
						WHERE       
							FP_FUNC_VALE_DEBITO.CD_EMP = 1 
							AND FP_FUNC_VALE_DEBITO.DT_VALE_DEB <  @DT_INI) T
						GROUP BY
							CD_EMP,
							CD_FUN,
							NM_FUN,
							CPF_FUN) VALE  

	UNION ALL
	SELECT		
		CD_EMP, 
		CD_FILIAL,
		CD_FUN, 
		NM_FUN COLLATE SQL_LATIN1_GENERAL_CP1_CI_AI, 
		DT_VALE, 
		DS_VALE, 
		VLR_VALE, 
		VLR_SLD_VALE, 
		TP_TRANSA,
		CASE WHEN CD_FILIAL = 0 THEN
			'LANÇAMENTO MANUAL'
		ELSE
			CASE WHEN DIF_CAIXA=0 THEN
				'ADIATAMENTO SALARIO'
			ELSE
				'FECHAMENTO DE CAIXA'
			END
		END,
		CPF COLLATE SQL_LATIN1_GENERAL_CP1_CI_AI,
		NM_USU
	FROM		
		@RS_MOV 
	ORDER BY 
		DT_VALE, 
		TP_TRANSA
RETURN
END

GO
